<?php
/**
 * Register a new setting
 **/



// Step 1: Create a function to display the settings page
function custom_settings_page() {
    ?>
    <div class="wrap custom-page-wrapper">
        <h2>تنظیمات عمومی</h2>
        <form method="post" action="options.php">
            <?php
            settings_fields('custom_settings_header_group');
            do_settings_sections('custom_settings_header');
            submit_button('ذخیره تنظیمات هدر');
            ?>
        </form>

        <form method="post" action="options.php">
            <?php
            settings_fields('custom_settings_footer_group');
            do_settings_sections('custom_settings_footer');
            submit_button('ذخیره تنظیمات فوتر');
            ?>
        </form>
    </div>
    <?php
}

// Step 3: Create a function to register and initialize the settings
    function custom_settings_init() {
        // Header Section
        add_settings_section(
            'custom_settings_header_section',
            'تنظیمات هدر',
            '',
            'custom_settings_header'
        );

        add_settings_field(
            'custom_setting_header_field',
            'تنظیمات',
            'custom_setting_header_field_callback',
            'custom_settings_header',
            'custom_settings_header_section'
        );


        register_setting(
            'custom_settings_header_group',
            'custom_setting_header_image'
        );

        register_setting(
            'custom_settings_header_group',
            'custom_setting_header_btn_1'
        );

        register_setting(
            'custom_settings_header_group',
            'custom_setting_header_btn_url_1'
        );
        register_setting(
            'custom_settings_header_group',
            'custom_setting_header_btn_2'
        );

        register_setting(
            'custom_settings_header_group',
            'custom_setting_header_btn_url_2'
        );

        // Footer Section
        add_settings_section(
            'custom_settings_footer_section',
            'تنظیمات فوتر',
            '',
            'custom_settings_footer'
        );

        add_settings_field(
            'custom_setting_footer_field',
            'تنظیمات',
            'custom_setting_footer_field_callback',
            'custom_settings_footer',
            'custom_settings_footer_section'
        );

        register_setting(
            'custom_settings_footer_group',
            'custom_setting_footer_1'
        );

        register_setting(
            'custom_settings_footer_group',
            'custom_setting_footer_2'
        );

        register_setting(
            'custom_settings_footer_group',
            'custom_setting_footer_3'
        );
        register_setting(
            'custom_settings_footer_group',
            'custom_setting_footer_btn'
        );

        register_setting(
            'custom_settings_footer_group',
            'custom_setting_footer_textarea'
        );
        register_setting(
            'custom_settings_footer_group',
            'custom_setting_footer_image'
        );
    }

function custom_setting_header_field_callback() {

    $image_url = get_option('custom_setting_header_image');
    $header_btn_1 = get_option('custom_setting_header_btn_1');
    $header_btn_url_1 = get_option('custom_setting_header_btn_url_1');
    $header_btn_2 = get_option('custom_setting_header_btn_2');
    $header_btn_url_2 = get_option('custom_setting_header_btn_url_2');

    echo '<div class="form-wrapper">';
    echo '<div class="form-row">';
        echo '<div class="col-25">';
        echo '<label for="custom_setting_header_btn_1">عنوان دکمه 1 :</label>';
        echo '<input type="text" id="custom_setting_header_btn_1" name="custom_setting_header_btn_1" value="' . esc_attr($header_btn_1) . '" />';
        echo '</div>';
        echo '<div class="col-25">';
        echo '<label for="custom_setting_header_btn_url_1">لینک دکمه 1 :</label>';
        echo '<input type="text" id="custom_setting_header_btn_url_1" name="custom_setting_header_btn_url_1" value="' . esc_attr($header_btn_url_1) . '" />';
        echo '</div>';
        echo '<div class="col-25">';
        echo '<label for="custom_setting_header_btn_2">عنوان دکمه 2 :</label>';
        echo '<input type="text" id="custom_setting_header_btn_2" name="custom_setting_header_btn_2" value="' . esc_attr($header_btn_2) . '" />';
        echo '</div>';
        echo '<div class="col-25">';
        echo '<label for="custom_setting_header_btn_url_2">لینک دکمه 2 :</label>';
        echo '<input type="text" id="custom_setting_header_btn_url_2" name="custom_setting_header_btn_url_2" value="' . esc_attr($header_btn_url_2) . '" />';
        echo '</div>';
    echo '</div>';
    echo '<div class="col-50">';
    echo '<label for="custom_setting_header_image">تصویر هدر:</label>';
    echo '<img class="header-img" src="' . esc_attr($image_url) . '" />';
    echo '<input type="text" id="custom_setting_header_image" name="custom_setting_header_image" value="' . esc_attr($image_url) . '" />';
    echo '<input type="button" id="upload_header_image_button" class="button" value="بارگذاری تصویر ">';
    echo '</div>';
    echo '</div>';
    echo '</div>'; ?>
    <script>
        jQuery(document).ready(function ($) {
            var customHeaderUploader;

            $('#upload_header_image_button').click(function (e) {
                e.preventDefault();

                if (customHeaderUploader) {
                    customHeaderUploader.open();
                    return;
                }

                customHeaderUploader = wp.media.frames.file_frame = wp.media({
                    title: 'Choose Header Image',
                    button: {
                        text: 'Choose Image'
                    },
                    multiple: false
                });

                customHeaderUploader.on('select', function () {
                    var attachment = customHeaderUploader.state().get('selection').first().toJSON();
                    $('#custom_setting_header_image').val(attachment.url);
                });

                customHeaderUploader.open();
            });
        });
    </script>
<?php
}


function custom_setting_footer_field_callback()
{
    $setting_value_1 = get_option('custom_setting_footer_1');
    $setting_value_2 = get_option('custom_setting_footer_2');
    $setting_value_3 = get_option('custom_setting_footer_3');
    $setting_value_btn = get_option('custom_setting_footer_btn');
    $textarea_value = get_option('custom_setting_footer_textarea');
    $image_url = get_option('custom_setting_footer_image');

    echo '<div class="form-wrapper">';
    echo '<div class="form-row">';

        echo '<div class="col-30">';
        echo '<label for="custom_setting_footer_1">عنوان منوی 1:</label>';
        echo '<input type="text" id="custom_setting_footer_1" name="custom_setting_footer_1" value="' . esc_attr($setting_value_1) . '" />';
        echo '</div>';

        echo '<div class="col-30">';
        echo '<label for="custom_setting_footer_2">عنوان منوی 2:</label>';
        echo '<input type="text" id="custom_setting_footer_2" name="custom_setting_footer_2" value="' . esc_attr($setting_value_2) . '" />';
        echo '</div>';

        echo '<div class="col-30">';
        echo '<label for="custom_setting_footer_3">متن کپی رایت :</label>';
        echo '<input type="text" id="custom_setting_footer_3" name="custom_setting_footer_3" value="' . esc_attr($setting_value_3) . '" />';
        echo '</div>';

        echo '<div class="col-50">';
        echo '<label for="custom_setting_footer_btn">عنوان دکمه :</label>';
        echo '<input type="text" id="custom_setting_footer_btn" name="custom_setting_footer_btn" value="' . esc_attr($setting_value_btn) . '" />';
        echo '</div>';

    echo '</div>';

    echo '<div class="form-row">';
    echo '<div class="col-50">';
        echo '<label for="custom_setting_footer_textarea">توضیحات:</label>';
        echo '<textarea id="custom_setting_footer_textarea" name="custom_setting_footer_textarea" rows="8" cols="50">' . esc_textarea($textarea_value) . '</textarea>';
    echo '</div>';

    echo '<div class="col-50">';
    // Image uploader
        echo '<label for="custom_setting_footer_image">لوگوی فوتر:</label>';
        echo '<img class="footer-img" src="' . esc_attr($image_url) . '" />';
        echo '<input type="text" id="custom_setting_footer_image" name="custom_setting_footer_image" value="' . esc_attr($image_url) . '" />';
        echo '<input type="button" id="upload_image_button" class="button" value="بارگذاری تصویر">';
    echo '</div>';
    echo '</div>';
    echo '</div>'; ?>
    <script >
    jQuery(document) . ready(function ($){
        var
        customUploader;

        $('#upload_image_button') . click(function (e) {
            e . preventDefault();

            // If the uploader object has already been created, reopen the dialog
            if (customUploader) {
                customUploader . open();
                return;
            }

            // Extend the wp.media object
            customUploader = wp . media . frames . file_frame = wp . media({
                    title: 'Choose Image',
                    button: {
                text:
                'Choose Image'
                    },
                    multiple: false
                });

                // When a file is selected, grab the URL and set it as the text field's value
                customUploader . on('select', function () {
                    var
                    attachment = customUploader . state() . get('selection') . first() . toJSON();
                    $('#custom_setting_footer_image') . val(attachment . url);
                });

                // Open the uploader dialog
                customUploader . open();
            });
    });
    </script >
<?php }
add_action('admin_menu', 'custom_settings_menu');
add_action('admin_init', 'custom_settings_init');

function custom_settings_menu() {
    add_menu_page(
        'Custom Settings',
        'تنظیمات عمومی',
        'manage_options',
        'custom-settings',
        'custom_settings_page'
    );
}

function enqueue_media_uploader_script() {
    if (is_admin()) {
        wp_enqueue_media();
    }
}
add_action('admin_enqueue_scripts', 'enqueue_media_uploader_script');


function enqueue_custom_styles() {
    wp_enqueue_style('custom-settings-styles', get_template_directory_uri() . '/assets/css/custom-settings-styles.css');
}
add_action('admin_enqueue_scripts', 'enqueue_custom_styles');