<?php
define('THEME_URL', get_template_directory_uri());
define('THEME_PATH', get_template_directory());

/**
 * Creating Menu
 **/
add_action('after_setup_theme', 'hinza_menus');
function hinza_menus(){
    register_nav_menus( array(
        'right'  => __( 'Right Menu (Main Menu)', 'hinza' ),
        'left'  => __( 'Left Menu', 'hinza' ),
        'mobile'  => __( 'Mobile Menu', 'hinza' ),
        'footer1'  => __( 'Footer 1 Menu', 'hinza' ),
        'footer2'  => __( 'Footer 2 Menu', 'hinza' ),
        'social'  => __( 'Social media', 'hinza' ),
    ) );
}

/**
 * Proper way to enqueue scripts and styles
 **/
function hinza_scripts(){
    wp_enqueue_script("jquery");
    wp_enqueue_script('custom', THEME_URL . '/assets/js/custom.js', array('jquery'), '', true);
    wp_enqueue_script('swiper', THEME_URL . '/assets/js/swiper.js', array('jquery'), '', true);

    wp_dequeue_style('wp-block-library');
    wp_enqueue_style('bootstrap', THEME_URL . '/assets/css/bootstrap.css');
//    wp_enqueue_style('swiper', THEME_URL . '/assets/css/swiper.css');
    wp_enqueue_style('style', THEME_URL . '/style.css');
    /*wp_enqueue_style('style2', THEME_URL . '/style2.css');
    wp_enqueue_style('style3', THEME_URL . '/style3.css');*/
}
add_action('wp_enqueue_scripts', 'hinza_scripts');

function add_scripts() {
    if( is_single() ){
        wp_enqueue_script('swiper', THEME_URL . '/assets/js/swiper.js', array(), '', true);
        wp_enqueue_script('gallery', THEME_URL . '/assets/js/gallery.js', array(), '', true);
        wp_enqueue_script('lightgallery', THEME_URL . '/assets/js/lightgallery.js', array(), '', true);
        wp_enqueue_style('lightgallery', THEME_URL . '/assets/css/lightgallery.css');
        wp_enqueue_style('editor', THEME_URL . '/assets/css/editor.css');
    }
}
add_action( 'wp_enqueue_scripts', 'add_scripts' );
/**
 * Remove version from head
 **/
remove_action('wp_head', 'wp_generator');

/**
 * After setup theme
 **/

add_action('after_setup_theme', 'hinza_theme_setup');
function hinza_theme_setup(){
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('html5',array( 'style', 'script' ));
    add_filter('use_default_gallery_style', '__return_false');
//    add_image_size( 'blog_image', 600,400,true );
//    add_image_size( 'img_project', 600,400,true );
}

/**
 * Clean Script Tag
 **/
if (!is_admin()) {
    add_filter('script_loader_tag', 'clean_script_tag');
}
function clean_script_tag($input){
    $input = str_replace("type='text/javascript' ", '', $input);
    return str_replace("'", '"', $input);
}

/**
 * Remove WP Version From Styles & Scripts
 **/
add_filter('style_loader_src', 'sdt_remove_ver_css_js', 9999);
add_filter('script_loader_src', 'sdt_remove_ver_css_js', 9999);
function sdt_remove_ver_css_js($src){
    if (strpos($src, 'ver='))
        $src = remove_query_arg('ver', $src);
    return $src;
}
/**
 * Disables Pesky Emojis
 **/
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('wp_print_styles', 'print_emoji_styles');
remove_action('admin_print_styles', 'print_emoji_styles');
remove_filter('the_content_feed', 'wp_staticize_emoji');
remove_filter('comment_text_rss', 'wp_staticize_emoji');
remove_filter('wp_mail', 'wp_staticize_emoji_for_email');

/**
 * Disables Embeds
 **/

function cb_disable_peskies_disable_embeds_rewrites($rules){
    foreach ($rules as $rule => $rewrite) {
        if (false !== strpos($rewrite, 'embed=true')) {
            unset($rules[$rule]);
        }
    }
    return $rules;
}

function cb_disable_peskies_disable_embeds_tiny_mce_plugin($plugins){
    return array_diff($plugins, array('wpembed'));
}
function cb_disable_peskies_disable_embeds_remove_rewrite_rules(){
    add_filter('rewrite_rules_array', 'cb_disable_peskies_disable_embeds_rewrites');
    flush_rewrite_rules();
}
function cb_disable_peskies_disable_embeds_flush_rewrite_rules(){
    remove_filter('rewrite_rules_array', 'cb_disable_peskies_disable_embeds_rewrites');
    flush_rewrite_rules();
}
function cb_disable_peskies_disable_embeds(){
    // Remove the REST API endpoint.
    remove_action('rest_api_init', 'wp_oembed_register_route');
    // Turn off oEmbed auto discovery.
    add_filter('embed_oembed_discover', '__return_false');
    // Don't filter oEmbed results.
    remove_filter('oembed_dataparse', 'wp_filter_oembed_result', 10);
    // Remove oEmbed discovery links.
    remove_action('wp_head', 'wp_oembed_add_discovery_links');
    // Remove oEmbed-specific JavaScript from the front-end and back-end.
    remove_action('wp_head', 'wp_oembed_add_host_js');
    add_filter('tiny_mce_plugins', 'cb_disable_peskies_disable_embeds_tiny_mce_plugin');
    // Remove all embeds rewrite rules.
    add_filter('rewrite_rules_array', 'cb_disable_peskies_disable_embeds_rewrites');
}
add_action('init', 'cb_disable_peskies_disable_embeds', 99);

register_activation_hook(__FILE__, 'cb_disable_peskies_disable_embeds_remove_rewrite_rules');

register_deactivation_hook(__FILE__, 'cb_disable_peskies_disable_embeds_flush_rewrite_rules');

/**
 * Custom Excerpt Content Function By Limit
 **/
function excerpt_content($limit) {
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt)."...";
    echo $excerpt;
}

/**
 * Move Textarea Comment to End of Form
 **/
function wpb_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
}
add_filter( 'comment_form_fields', 'wpb_move_comment_field_to_bottom' );

/**
 * Enqueue JS Ajax Form Comment
 **/
function mytheme_enqueue_comment_reply(){
    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'mytheme_enqueue_comment_reply');

/**
 * Convert Input Submit To Button Submit
 **/
function awesome_comment_form_submit_button($button) {
    $button = "<button id='submit' class='button'>ارسال</button>";
    return $button;
}
add_filter('comment_form_submit_button', 'awesome_comment_form_submit_button');

add_filter('gform_submit_button', 'form_submit_button', 10, 2);
function form_submit_button($button, $form){
    return "<button class='button gform_button' id='gform_submit_button_{$form['id']}'><span>" . $form['button']['text'] . "</span></button>";
}

/**
 * Remove Comment Cookies
 **/
remove_action( 'set_comment_cookies', 'wp_set_comment_cookies' );

/**
 * Add Custom Class to Body In Inner Pages
 **/
add_filter( 'body_class', function( $classes ) {
    if (!is_front_page()) {
        return array_merge($classes, array('inner-page'));
    }else{
        return array_merge($classes);
    }
} );

/**
 * Add Sidebar for blog
 **/
register_sidebar(array(
    'name' => 'سایدبار بلاگ',
    'id' => 'sidebar_blog',
    'before_widget' => '<div id="%1$s" class="widget widget-side mb-4 %2$s">',
    'after_widget' => '</div>',
    'before_title' => '<div class="widget-title"><h4>',
    'after_title' => '</h4></div>',
));

/**
 * Customize title of archive
 **/

add_filter( 'get_the_archive_title', function ($title) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_tax() ) {
        $title = sprintf( __( '%1$s' ), single_term_title( '', false ) );
    } elseif (is_post_type_archive()) {
        $title = post_type_archive_title( '', false );
    }
    return $title;
});

/**
 * Upload SVG
 **/
function add_svg_to_upload_mimes($upload_mimes) {
    $upload_mimes['svg'] = 'image/svg+xml';
    $upload_mimes['svgz'] = 'image/svg+xml';
    return $upload_mimes;
}
add_filter('upload_mimes', 'add_svg_to_upload_mimes', 10, 1);