<?php
/**
 * The template for displaying singular post-types: posts, pages and user-defined custom post types.
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
get_header();

while ( have_posts() ) :
    the_post();
    ?>
    <main id="content">
        <div class="container">
            <div class="row">
                <div class="col-lg-9">
                    <div class="single-top">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="single-info-wrapper">
                                    <header class="title-site">
                                        <?php the_title( '<h1 class="title-inner">', '</h1>' ); ?>
                                    </header>
                                    <div>
                                        <div class="single-info">
                                            <!--            categories/Start-->
                                            <div class="single-categories">
                                                <span>دسته بندی ها : </span>
                                                <?php
                                                hinza_get_post_cat();
                                                ?>
                                            </div>
                                            <!--            categories/End-->
                                            <!--            date/Start-->
                                            <div class="single-date">
                                                <span class="date-title">تاریخ انتشار :</span>
                                                <span>
                                                <?php echo get_the_date('d M Y'); ?>
                                            </span>
                                            </div>
                                            <!--            date/End-->
                                        </div>
                                        <div class="expert-wrapper">
                                            <!--            expert/Start-->
                                            <div class="short-dsc">
                                                <div class="blog-expert my-2">
                                                    <?php
                                                    if(get_the_excerpt()){
                                                        echo get_the_excerpt();
                                                    }else{
                                                        echo excerpt_content(20);
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <!--             expert/End-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <!--            img/Start-->
                                <div class="img-thumbnail">
                                    <?php
                                    hinza_show_img()
                                    ?>
                                </div>
                                <!--            img/End-->
                            </div>
                        </div>
                    </div>
                    <div class="page-content editor-content">
                        <!--        content/Start-->
                        <div class="editor-content">
                            <?php the_content(); ?>
                        </div>
                        <!--        content/End-->
                        <!--        tags/Start-->
                        <div class="post-tags">
                            <?php the_tags( '<div class="tag-links">' . esc_html__( 'برچسب ها :' ), null, '</div>' ); ?>
                        </div>
                        <!--        tags/End-->
                        <?php wp_link_pages(); ?>
                    </div>
                </div>
                <div class="col-lg-3 d-none d-lg-block">
                    <div class="blog-sidebar">
                        <?php dynamic_sidebar( 'sidebar_blog' ); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="blog-pagination">
            <?php the_post_navigation(array(
                'prev_text' => __('<i aria-hidden="true" class="fas fa-chevron-right"></i> مقاله قبلی : %title'),
                'next_text' => __(' مقاله بعدی : %title<i aria-hidden="true" class="fas fa-chevron-left"></i>'),
            ));; ?>
        </div>
    </main>

<?php
endwhile;
?>
<?php //if($related_post){ ?>
<!--    <div class="dark-section related-product">-->
<!--        <div class="related-posts">-->
<!--            <div class="related-title-wrapper">-->
<!--                <h3>محصولات مرتبط</h3>-->
<!--            </div>-->
<!--            <div class="row">-->
<!--                --><?php
//
//                $args = array(
//                    'post_type' => 'products',
//                    'post_status' => 'publish',
//                    'post__in' => explode(',',$related_product),
//                    'posts_per_page' => 4,
//                );
//                $loop = new WP_Query($args);
//
//                while ($loop->have_posts()) : $loop->the_post();
//                    echo '<div class="col-lg-3 col-md-6 col-sm-6">';
//                    get_template_part('template-parts/product/card' , 'page');
//                    echo '</div>';
//                endwhile;
//
//                wp_reset_postdata();
//                ?>
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<?php //} ?>
<?php //if($related_post){ ?>
<!--    <div class="related-posts related-post-single">-->
<!--        <div class="related-title-wrapper">-->
<!--            <h3>مقالات مرتبط</h3>-->
<!--        </div>-->
<!--        <div class="row">-->
<!--            --><?php
//
//            $args = array(
//                'post_type' => 'post',
//                'post_status' => 'publish',
//                'post__in' => explode(',',$related_post),
//                'posts_per_page' => 4,
//            );
//            $loop = new WP_Query($args);
//
//            while ($loop->have_posts()) : $loop->the_post();
//                echo '<div class="col-lg-3 col-md-6 col-sm-6">';
//                get_template_part('template-parts/cart-blog');
//                echo '</div>';
//            endwhile;
//
//            wp_reset_postdata();
//            ?>
<!--        </div>-->
<!--    </div>-->
<?php
get_footer();
?>
