<?php /* Template Name: پروژه ها */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
get_header()
?>
<main id="content" class="site-main">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <header class="page-header title-site">
                    <?php
                        echo '<h1 class="entry-title">';
                        echo get_the_title();
                        echo '</h1>';
                        if(get_the_content()){
                            echo  '<div class="title-desc">'.get_the_content().'</div>';
                        }
                    ?>
                </header>
                <div class="page-content">
                    <div class="row">
                        <?php
                        $args = array(
                            'post_type' => 'service',
                            'post_status' => 'publish',
                            'posts_per_page' => -1,
                            'orderby' => 'date',
                            'order' => 'ASC',
                        );

                        $loop = new WP_Query( $args );

                        while ( $loop->have_posts() ) : $loop->the_post();
                            echo '<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 mb-4">';
                            get_template_part('template-parts/card/card','project');
                            echo '</div>';
                        endwhile;

                        wp_reset_postdata(); ?>
                    </div>
                </div>

                <?php wp_link_pages(); ?>
                <div class="archive-pag">
                    <?php echo the_posts_pagination() ?>
                </div>
            </div>
        </div>
    </div>
</main>
<?php
get_footer()
?>
