<?php
/**
 * The template for displaying archive pages.
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
get_header()
?>
<main id="content" class="site-main">
    <div class="container">
        <div class="row">
            <div class="col-lg-9">
                <header class="page-header title-site">
                    <?php
                    if(is_archive()){
                        echo '<h1 class="entry-title">';
                        echo get_the_archive_title();
                        echo '</h1>';
                    }else{
                        echo '<h1 class="entry-title">';
                        echo 'اخبار و مقالات';
                        echo '</h1>';
                    }
                    ?>
                </header>
                <div class="page-content">
                    <div class="row">
                        <?php
                        while ( have_posts() ) {
                            the_post();
                            echo '<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 mb-4">';
                            get_template_part('template-parts/card/card','blog');
                            echo '</div>';
                            ?>
                        <?php } ?>
                    </div>
                </div>

                <?php wp_link_pages(); ?>
                <div class="archive-pag">
                    <?php echo the_posts_pagination() ?>
                </div>
            </div>
            <div class="col-lg-3 d-none d-lg-block">
                <div class="blog-sidebar">
                    <?php dynamic_sidebar( 'sidebar' ); ?>
                </div>
            </div>
        </div>
    </div>
</main>
<?php
get_footer()
?>