jQuery(document).ready(function($) {
    // Smooth scrolling when clicking on links
    $('a[href*="#"]').on('click', function(e) {
        e.preventDefault();

        $('html, body').animate(
            {
                scrollTop: $($(this).attr('href')).offset().top
            },
            100000, // Adjust the speed (milliseconds)
            'swing'
        );
    });
});

gsap.registerPlugin(ScrollTrigger);

gsap.utils.toArray(".section").forEach(section => {
    gsap.from(section, {
        y: 80,
        opacity: 0,
        duration: 1,
        scrollTrigger: {
            trigger: section,
            start: "top 90%",
            toggleActions: "play none none reverse"
        }
    });
});