<?php
require_once "includes/admin-functions.php";
require_once "includes/validation.php";
require_once "includes/xss_clean.php";
require_once "includes/template-config.php";
require_once "includes/template-functions.php";
/*require_once "includes/admin-rules.php";*/
require_once "includes/custom-setting.php";

// Limit login failed
function limit_login_attempts() {
    $login_attempts = 3; // Set the number of allowed login attempts
    $timeout_minutes = 15; // Set the timeout (in minutes) for login attempts

    $login_lockout = get_option('login_lockout', array());
    $user_ip = $_SERVER['REMOTE_ADDR'];

    if (!isset($login_lockout[$user_ip])) {
        $login_lockout[$user_ip] = array();
    }

    $login_lockout[$user_ip][] = time();

    $login_lockout[$user_ip] = array_filter($login_lockout[$user_ip], function ($attempt_time) use ($timeout_minutes) {
        return $attempt_time > (time() - $timeout_minutes * 60);
    });

    if (count($login_lockout[$user_ip]) > $login_attempts) {
        header('HTTP/1.0 403 Forbidden');
        exit;
    }

    update_option('login_lockout', $login_lockout);
}

add_action('wp_login_failed', 'limit_login_attempts');



// Filter & Function to rename the WordPress logout URL
add_filter( 'logout_url', 'hinza_logout_page', 10, 2 );
function hinza_logout_page( $logout_url) {
    return home_url( '/loginhinzadmin.php');   // The name of your new login file
}
// Filter & Function to rename Lost Password URL
add_filter( 'lostpassword_url', 'hinza_lost_password_page', 10, 2 );
function hinza_lost_password_page( $lostpassword_url ) {
    return home_url( '/loginhinzadmin.php?action=lostpassword');   // The name of your new login file
}



add_filter( 'get_the_archive_title', 'custom_archive_title' );

function custom_archive_title( $title ) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title = '<span class="vcard">' . get_the_author() . '</span>' ;
    } elseif ( is_tax() ) { // Custom taxonomies
        $title = single_term_title( '', false );
    } elseif ( is_post_type_archive() ) {
        $title = post_type_archive_title( '', false );
    } elseif ( is_archive() ) {
        $title = __( 'Blog', 'textdomain' ); // Change 'Blog' to your desired title
    }

    return $title;
}

function custom_gsap_scripts() {
    wp_enqueue_script('gsap', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js', [], null, true);
    wp_enqueue_script('gsap-scrolltrigger', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/ScrollTrigger.min.js', ['gsap'], null, true);
    wp_enqueue_script('custom-gsap', get_stylesheet_directory_uri() . '/js/custom.js', ['gsap', 'gsap-scrolltrigger'], null, true);
}
add_action('wp_enqueue_scripts', 'custom_gsap_scripts');
