<?php
function post_type_product() {
    $supports = array(
        'title',
        'editor',
        'thumbnail',
        'excerpt',
        'custom-fields',
        'revisions',
        'post-formats',
    );
    $labels = array(
        'name' => _x('محصولات', 'plural'),
        'singular_name' => _x('محصولات', 'singular'),
        'menu_name' => _x('محصولات', 'admin menu'),
        'name_admin_bar' => _x('محصولات', 'admin bar'),
        'add_new' => _x('افزودن جدید', 'add new'),
        'add_new_item' => __('افزودن محصول جدید'),
        'new_item' => __('محصولات جدید'),
        'edit_item' => __('ویرایش محصولات'),
        'view_item' => __('مشاهده محصولات'),
        'all_items' => __('همه محصولات'),
        'search_items' => __('جستجو محصولات'),
        'not_found' => __('هیچ محصولی یافت نشد'),
    );
    $args = array(
        'supports' => $supports,
        'labels' => $labels,
        'public' => true,
        'menu_position' => 4,
        'query_var' => true,
        'rewrite' => array('slug' => 'product'),
        'has_archive' => true,
        'hierarchical' => false,
    );
    register_post_type('product', $args);
}
add_action('init', 'post_type_product');
//-------- Add custom post type/End ---------

//------- Add category to product post type/Start------------
function product_category() {
    $labels = array(
        'name' => 'دسته بندی ها',
        'singular_name' => 'دسته بندی',
        'menu_name' => 'دسته بندی ها',
    );

    $args = array(
        'labels' => $labels,
        'hierarchical' => true,  // Set to true if you want a hierarchical taxonomy like categories
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'product_categories'),
    );

    register_taxonomy('product_categories', 'product', $args);
}
add_action('init', 'product_category');

//------- Add category to product post type/End------------

//------- Add taxonomy to product post type/Start----------
function product_taxonomy() {
    register_taxonomy(
        'product_tag',
        'product',
        array(
            'label' => 'برچسب ها',
            'rewrite' => array('slug' => 'product-tag'),
            'hierarchical' => false,
        )
    );
}
add_action('init', 'product_taxonomy');
//------- Add taxonomy to product post type/End------------

//------- Add custom post type/Start---------
function post_type_project() {
    $supports = array(
        'title',
        'editor',
        'thumbnail',
        'excerpt',
        'custom-fields',
        'revisions',
        'post-formats',
    );
    $labels = array(
        'name' => _x('پروژه ها', 'plural'),
        'singular_name' => _x('پروژه ها', 'singular'),
        'menu_name' => _x('پروژه ها', 'admin menu'),
        'name_admin_bar' => _x('پروژه ها', 'admin bar'),
        'add_new' => _x('افزودن جدید', 'add new'),
        'add_new_item' => __('افزودن پروژه جدید'),
        'new_item' => __('پروژه های جدید'),
        'edit_item' => __('ویرایش پروژه ها'),
        'view_item' => __('مشاهده پروژه ها'),
        'all_items' => __('همه پروژه ها'),
        'search_items' => __('جستجو پروژه ها'),
        'not_found' => __('هیچ پروژه ای یافت نشد'),
    );
    $args = array(
        'supports' => $supports,
        'labels' => $labels,
        'public' => true,
        'menu_position' => 5,
        'query_var' => true,
        'rewrite' => array('slug' => 'project/%project_categories%'),
        'has_archive' => true,
        'hierarchical' => false,
    );
    register_post_type('project', $args);
}
add_action('init', 'post_type_project'); // Corrected function name
//-------- Add custom post type/End ---------

//------- Add category to project post type/Start------------
function project_category() {
    $labels = array(
        'name' => 'دسته بندی ها',
        'singular_name' => 'دسته بندی',
        'menu_name' => 'دسته بندی ها',
    );

    $args = array(
        'labels' => $labels,
        'hierarchical' => true,  // Set to true if you want a hierarchical taxonomy like categories
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'project'),
    );

    register_taxonomy('project_categories', 'project', $args);
}
add_action('init', 'project_category');

//------- Add category to project post type/End------------

//------- Add taxonomy to project post type/Start----------
function project_taxonomy() {
    register_taxonomy(
        'project_tag',
        'project',
        array(
            'label' => 'برچسب ها',
            'rewrite' => array('slug' => 'project-tag'),
            'hierarchical' => false,
        )
    );
}
add_action('init', 'project_taxonomy');
//------- Add taxonomy to product post type/End------------

//------- Single post functions/Start------------
function hinza_get_post_cat(){
    $post = get_post();
    if ( $post ) {
        $categories = get_the_category( $post->ID );
        foreach ( $categories as $category ) {
            echo '<a href="'.esc_url( get_category_link( $category->term_id ) ).'">'.$category->name.'</a>';
        }
    }
}

function hinza_show_img(){
    if(get_the_post_thumbnail()){
        echo '<a href="'.get_the_permalink().'">'.get_the_post_thumbnail().'</a>';
    }else{
        echo '<a href="'.get_the_permalink().'"><img src="'.THEME_URL.'/assets/img/placeholder.jpg"></a>';
    }
}
//------- Single post functions/End ------------

//------- shortcode to show project/Start ---------
function show_project_shortcode($atts) {
    // Extract shortcode attributes, default is empty
    $atts = shortcode_atts(
        array(
            'ids' => '', // Allow passing post IDs
        ),
        $atts,
        'projects' // Shortcode name
    );

    // Convert comma-separated IDs to an array
    $post_ids = !empty($atts['ids']) ? explode(',', $atts['ids']) : array();

    echo '<div class="swiper-container swiper-project">';
    echo '<div class="swiper-wrapper">';

    // Arguments for WP_Query
    $args = array(
        'post_type' => 'project',
        'post_status' => 'publish',
        'posts_per_page' => 6,
        'orderby' => 'rand',
        'tax_query' => array(
            array(
                'taxonomy' => 'project_categories',
                'field' => 'slug',
                'terms' => 'success-story',
            ),
        ),
    );

    // If specific post IDs are provided, add them to the query
    if (!empty($post_ids)) {
        $args['post__in'] = $post_ids;
        $args['orderby'] = 'post__in'; // Order by the order of IDs
    }

    $loop = new WP_Query($args);

    while ($loop->have_posts()) : $loop->the_post();
        echo '<div class="swiper-slide">';
            echo '<div class="home-project-wrapper">';
                echo '<div class="home-project-img">';
                    hinza_show_img();
                echo '</div>';
                echo '<div class="home-project-info">';
?>
                <div class="home-project-category">
                    <?php
                    $industry = get_post_meta(get_the_ID(), 'industry', true);

                    if ($industry) {
                        echo esc_html($industry);
                    }
                    ?>
                </div>
                <h2 class="home-project-title">
                    <?php echo get_the_title(); ?>
                </h2>
                <div class="home-project-desc">
                    <?php echo get_the_excerpt(); ?>
                </div>
                <div class="home-project-more">
                    <a href="<?php echo get_the_permalink(); ?>" class="read-more-project">
                        مشاهده جزئیات
                        <i aria-hidden="true" class="fas fa-arrow-left"></i>
                    </a>
                </div>
<?php
                echo '</div>';
            echo '</div>';
        echo '</div>';
    endwhile;

    wp_reset_postdata();

    echo '</div>';
    echo '<div class="custom-swiper-navigation">';
        echo '<div class="swiper-button-next"></div>';
        echo '<div class="swiper-button-prev"></div>';
    echo '</div>';
    echo '<div class="swiper-slide-number">';
        echo '<span class="current">1</span> / <span class="total"></span>';
    echo '</div>';
    echo '<div class="swiper-pagination project-pagination"></div>';
    echo '</div>';
}

// Register the shortcode [projects ids="4416,4390,4208,4192,4218,4201"]
add_shortcode('projects', 'show_project_shortcode');

//------- shortcode to show project/End ---------
//------- shortcode to show post/Start ---------
function show_post_shortcode($atts) {
    echo '<div class="row">';
        $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => 2,
        );

        $loop = new WP_Query( $args );

        while ( $loop->have_posts() ) : $loop->the_post();
            echo '<div class="col-lg-6 col-sm-6 card-blog-wrapper">';
                echo get_template_part('template-parts/card/card','blog');
            echo '</div>';
        endwhile;

        wp_reset_postdata();
    echo '</div>';
}

add_shortcode('post', 'show_post_shortcode');
//------- shortcode to show post/End ---------
//------- add category to project url/Start ---------
function custom_post_type_permalink($post_link, $id = 0) {
    $post = get_post($id);

    if (is_object($post) && $post->post_type == 'project') {
        $terms = wp_get_object_terms($post->ID, 'project_categories');
        if ($terms) {
            return str_replace('%project_categories%', $terms[0]->slug, $post_link);
        }
    }

    return $post_link;
}
add_filter('post_type_link', 'custom_post_type_permalink', 1, 3);

//------- add category to project url/End ---------

//------- shortcode to show post/Start ---------
function show_post_cat() {
    echo '<div class="row cat-top">';

    $args = array(
        'posts_per_page' => 2,
    );

    $query = new WP_Query($args);

    while ($query->have_posts()) {
        $query->the_post();
        echo '<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 mb-3 mb-md-0">';
        get_template_part('template-parts/card/card', 'blog');
        echo '</div>';
    }

    wp_reset_postdata();

    echo '</div>';
}

add_shortcode('post_cat', 'show_post_cat');

function show_post_all() {
    echo '<div class="row">';

    $args = array(
        'offset' => 2,
    );

    $query = new WP_Query($args);

    while ($query->have_posts()) {
        $query->the_post();
        echo '<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 mb-3 mb-md-5">';
        get_template_part('template-parts/card/card', 'blog');
        echo '</div>';
    }

    wp_reset_postdata();

    echo '</div>';
    $pagination_args = array(
        'mid_size'  => 1,
        'next_text' => __('<span class="elementor-button-icon elementor-align-icon-left"><svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-left" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg"><path d="M257.5 445.1l-22.2 22.2c-9.4 9.4-24.6 9.4-33.9 0L7 273c-9.4-9.4-9.4-24.6 0-33.9L201.4 44.7c9.4-9.4 24.6-9.4 33.9 0l22.2 22.2c9.5 9.5 9.3 25-.4 34.3L136.6 216H424c13.3 0 24 10.7 24 24v32c0 13.3-10.7 24-24 24H136.6l120.5 114.8c9.8 9.3 10 24.8.4 34.3z"></path></svg></span>', 'textdomain'),
        'prev_text' => __('<span class="elementor-button-icon elementor-align-icon-left"><svg aria-hidden="true" class="e-font-icon-svg e-fas-arrow-right" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z"></path></svg></span>', 'textdomain'),
        );
    wp_link_pages();
    echo '<div class="custom-pagination">';
    echo the_posts_pagination($pagination_args);
    echo '</div>';
}

add_shortcode('post_all', 'show_post_all');

//------- shortcode to show post/End ---------
function add_smooth_scroll_script() {
        wp_enqueue_script('smooth-scroll', get_template_directory_uri() . 'assets\js\custom.js', array('jquery'), null, true);
}

add_shortcode('wp_enqueue_script', 'add_smooth_scroll_script');


/*-------- swiper css -----------------*/
function swiper_styles() {
    wp_enqueue_style('swiper', get_stylesheet_directory_uri() . 'assets/css/swiper.css', array(), '1.0', 'all');
}
add_action('wp_enqueue_scripts', 'swiper_styles');


