<?php
    $color = get_post_meta(get_the_ID())['color'][0];
    $style = 'style = "background:'.$color.'"'
?>
<article class="project-card" <?php echo $style ?>>
    <div class="project-img-wrapper">
        <?php hinza_show_img() ?>
    </div>
    <div class="project-content-wrapper">
        <div class="project-header">
            <div class="project-category">
                <?php
                $categories = get_the_terms(get_the_ID(), 'service_categories');

                if ($categories && !is_wp_error($categories)) {
                    $category_links = array();

                    foreach ($categories as $category) {
                        $category_links[] = '<a href="' . get_term_link($category) . '">' . $category->name . '</a>';
                    }

                    echo implode(', ', $category_links);
                    echo '</p>';
                }
                ?>
            </div>
            <h2 class="project-title">
                <?php echo get_the_title(); ?>
            </h2>
        </div>
        <div class="project-desc">
            <?php echo get_the_excerpt(); ?>
        </div>
        <div class="project-tags">
            <div class="project-tag">
                <?php
                $categories = get_the_terms(get_the_ID(), 'service_tag');

                if ($categories && !is_wp_error($categories)) {
                    $category_links = array();

                    foreach ($categories as $category) {
                        $category_links[] = '<a href="' . get_term_link($category) . '">' . $category->name . '</a>';
                    }

                    echo implode('', $category_links);
                    echo '</p>';
                }
                ?>
            </div>
        </div>
    </div>

</article>